function [EH] = CDDA_solution(pos, alphae, alphah, alphaeh,...
      EH0, k0, epsout)

% Main program of calculation once the geometry of the scatterer and the
% illumination is defined.

%%%%%% INPUT ARGUMENTS %%%%%%
%%% pos:     position of the dipoles                                 %%%
%%% alphae:  electric polarizabilities of the dipoles                %%%
%%% alphah:  magnetic polarizabilities of the dipoles                %%%
%%% alphaeh: mixed magnetic electric polarizabilities of the dipoles %%%
%%% EH0:     exciting electromagnetic wave (6D vectorial function)   %%%
%%% k0:      wavenumber                                              %%%
%%% espout:  surrounding permittivity                                %%%


%%%%%% OUTPUT ARGUMENTS %%%%%%
%%% EH: total incident field (exciting wave + scattered field) in the %%%
%%%     dipoles %%%

% Constants %
load('vacPer.mat','eps0','mu0');
eps0 = epsout*eps0;
Z0   = sqrt(mu0/eps0);

% Data for loops %
K  = length(k0);
N  = length(pos(:,1));
EH = zeros(K,N,6);

% If L = 2, the polarizability is wavelength indepndent and the same for
% all dipole. If K>1 and L = 3 the polarizability is only a function of
% the wavelength and if L = 4 it also depends on the position (dipole).
% If K = 1 and L = 3 it only depndends on the position and if L = 2 the
% polarizability is wavelength independent and the same for all dipoles.
S = size(alphae);
L = length(S);

if(K > 1)
    parfor i = 1:K
        if(L == 4) % Wavelength and position dependent polarizability %
            ae  = squeeze(alphae(i,:,:,:));
            ah  = squeeze(alphah(i,:,:,:));
            aeh = squeeze(alphaeh(i,:,:,:));
        else % L = 3 (Wavelength dependent polarizability) %
            ae  = squeeze(alphae(i,:,:));
            ah  = squeeze(alphah(i,:,:));
            aeh = squeeze(alphaeh(i,:,:));            
        end
            
            % Generating coupling matrix %
            C  = global_interaction_matrix(pos,ae,ah,aeh,k0(i),eps0,mu0);
            % Solving sytem of equations %
            EH(i,:,:) = equation_solving(C,EH0,k0(i),pos,Z0);

    end
else % L = 2 or 3 (wavelength independent polarizability) %

    % Generating coupling matrix %
    C  = global_interaction_matrix(pos,alphae,alphah,alphaeh,k0,eps0,mu0);
    % Solving sytem of equations %
    EH(1,:,:) = equation_solving(C,EH0,k0,pos,Z0);

end


end
